/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.particle;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_4002;
import net.minecraft.class_702;
import net.minecraft.class_707;

public final class ParticleFactoryRegistryImpl
implements ParticleFactoryRegistry {
    public static final ParticleFactoryRegistryImpl INSTANCE = new ParticleFactoryRegistryImpl();
    ParticleFactoryRegistry internalRegistry = new DeferredParticleFactoryRegistry();

    private ParticleFactoryRegistryImpl() {
    }

    @Override
    public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
        this.internalRegistry.register(type, factory);
    }

    @Override
    public <T extends class_2394> void register(class_2396<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
        this.internalRegistry.register(type, constructor);
    }

    public void initialize(class_702 particleManager) {
        DirectParticleFactoryRegistry newRegistry = new DirectParticleFactoryRegistry(particleManager);
        DeferredParticleFactoryRegistry oldRegistry = (DeferredParticleFactoryRegistry)this.internalRegistry;
        oldRegistry.applyTo(newRegistry);
        this.internalRegistry = newRegistry;
    }

    static class DeferredParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private final Map<class_2396<?>, class_707<?>> factories = new IdentityHashMap();
        private final Map<class_2396<?>, ParticleFactoryRegistry.PendingParticleFactory<?>> constructors = new IdentityHashMap();

        DeferredParticleFactoryRegistry() {
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
            this.factories.put(type, factory);
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> factory) {
            this.constructors.put(type, factory);
        }

        void applyTo(ParticleFactoryRegistry registry) {
            class_2396<?> type;
            for (Map.Entry<class_2396<?>, class_707<?>> entry : this.factories.entrySet()) {
                type = entry.getKey();
                class_707<?> factory = entry.getValue();
                registry.register(type, factory);
            }
            for (Map.Entry<class_2396<?>, Object> entry : this.constructors.entrySet()) {
                type = entry.getKey();
                ParticleFactoryRegistry.PendingParticleFactory constructor = (ParticleFactoryRegistry.PendingParticleFactory)entry.getValue();
                registry.register(type, constructor);
            }
        }
    }

    static class DirectParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private final class_702 particleManager;

        DirectParticleFactoryRegistry(class_702 particleManager) {
            this.particleManager = particleManager;
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, class_707<T> factory) {
            ((ParticleManagerAccessor)this.particleManager).getFactories().put(class_2378.field_11141.method_10206(type), factory);
        }

        @Override
        public <T extends class_2394> void register(class_2396<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
            class_702.class_4090 delegate = new class_702.class_4090();
            FabricSpriteProviderImpl fabricSpriteProvider = new FabricSpriteProviderImpl(this.particleManager, (class_4002)delegate);
            ((ParticleManagerAccessor)this.particleManager).getSpriteAwareFactories().put(class_2378.field_11141.method_10221(type), (class_4002)delegate);
            this.register(type, constructor.create(fabricSpriteProvider));
        }
    }
}

